package kom.itbeankit.common.message;


import java.awt.*;

import symantec.itools.awt.WrappingLabel;
//import symantec.itools.multimedia.ImageViewer;
//import symantec.itools.multimedia.SoundPlayer;
public class MessageDialog extends Dialog {

    //{{DECLARE_CONTROLS
	java.awt.Button okButton;
	symantec.itools.awt.WrappingLabel wrappingLabel;
	//}}
    //ItDrawImage theGif;
    //ItPlaySound theClip;

	public MessageDialog(Frame parent, boolean modal)
	{
		super(parent, modal);

		// This code is automatically generated by Visual Cafe when you add
		// components to the visual environment. It instantiates and initializes
		// the components. To modify the code, only use code syntax that matches
		// what Visual Cafe can generate, or Visual Cafe may be unable to back
		// parse your Java file into its visual environment.

		//{{INIT_CONTROLS
		setLayout(null);
		setVisible(false);
		setSize(297,144);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setForeground(new Color(0));
		setBackground(new Color(16777215));
		okButton = new java.awt.Button();
		okButton.setLabel("OK");
		okButton.setBounds(108,108,70,30);
		okButton.setFont(new Font("Dialog", Font.BOLD, 12));
		okButton.setBackground(new Color(12632256));
		add(okButton);
		okButton.setCursor(new Cursor(Cursor.HAND_CURSOR));
		wrappingLabel = new symantec.itools.awt.WrappingLabel();
		wrappingLabel.setBounds(12,12,276,84);
		add(wrappingLabel);
		setTitle("Info");
		//}}
      
        // theGif = new ItDrawImage("images/info.gif");
        // theClip = new ItPlaySound("sounds/info.au");

		//{{REGISTER_LISTENERS
		SymWindow aSymWindow = new SymWindow();
		this.addWindowListener(aSymWindow);
		SymAction lSymAction = new SymAction();
		okButton.addActionListener(lSymAction);
		//}}

	}
	public MessageDialog(Frame parent, MessageEvent me)
	{
		this(parent, true);
		int msgType = me.getMsgType();
		String title ="";
		String msg =me.getMsg();
		String msgSrc = me.getMsgSource();
		if(!msgSrc.equals(""))
		    msg = msgSrc +": "+ msg;
		switch(msgType){
		    case MessageEvent.MSG_TYPE_INFO:
		        title = MessageTexts.MSG_TYPE_INFO;
        //        theGif = new ItDrawImage("images/info.gif");
        //        theClip = new ItPlaySound("sounds/info.au");
		    break;
		    case MessageEvent.MSG_TYPE_WARNING:
		        title = MessageTexts.MSG_TYPE_WARNING;
        //        theGif = new ItDrawImage("images/warning.gif");
        //        theClip = new ItPlaySound("sounds/warning.au");
		    break;
		    case MessageEvent.MSG_TYPE_ERROR:
		        title = MessageTexts.MSG_TYPE_ERROR;
        //        theGif = new ItDrawImage("images/error.gif");
        //        theClip = new ItPlaySound("sounds/error.au");
		    break;
		    default:
		}
		
		//imagePanel1.add("Center", theGif);
		
		setTitle(title);
		try{
		    wrappingLabel.setText(msg);
		}
		catch(Exception e){}
	}


	public MessageDialog(Frame parent, String title, boolean modal)
	{
		this(parent, modal);
		setTitle(title);
	}



	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
                Dimension d = getSize();

		super.addNotify();

		// Only do this once.
		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}

		// Used for addNotify check.
		fComponentsAdjusted = true;
	}

	public void setVisible(boolean b)
	{
	    if (b)
	    {
    		Rectangle bounds = getParent().bounds();
    		Rectangle abounds = bounds();

    		move(bounds.x + (bounds.width - abounds.width)/ 2,
    			 bounds.y + (bounds.height - abounds.height)/2);
	    }

		super.setVisible(b);
	}



        // Used for addNotify check.
	boolean fComponentsAdjusted = false;

	class SymWindow extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == MessageDialog.this)
				MessageDialog_WindowClosing(event);
		}
	}

	void MessageDialog_WindowClosing(java.awt.event.WindowEvent event)
	{
                dispose();
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == okButton)
				okButton_Clicked(event);
		}
	}

	void okButton_Clicked(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Clicked from okButton Hide the Dialog
                dispose();
		//}}
	}
}
